#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <deque>
#include <queue>
#include <stack>
#include <algorithm>


#define forn(i, n) for(int i = 0; i < int(n); i++)
#define mp make_pair
#define pb push_back
#define foreach(it, v) for(__typeof(v.begin()) it = v.begin(); it != v.end(); ++it)

using namespace std;

typedef long long ll;

struct Person {
	int a, b, c;
	
	Person() {}
	Person(int a, int b, int c) : a(a), b(b), c(c) {}
	
	bool operator < (const Person & other) const {
		return a < other.a;
	}
};

const int kMaxN = 100010;

int tests;
int n;
Person persons[kMaxN];
int segTree[4 * kMaxN];

int segGet(int v, int l, int r, int tl, int tr) {
	if(tl > tr) return 0;
	if(l == tl && r == tr) return segTree[v];
	int m = (l + r) / 2, result = 0;
	if(tl <= m)
		result = segGet(2 * v, l, m, tl, min(tr, m));
	if(tr > m)
		result = max(result, segGet(2 * v + 1, m + 1, r, max(m + 1, tl), tr));
	return result;
}

void segInsert(int v, int l, int r, int index, int value) {
	if(l == r) {
		segTree[v] = value;
	} else {
		int m = (l + r) / 2;
		if(index <= m)
			segInsert(2 * v, l, m, index, value);
		else
			segInsert(2 * v + 1, m + 1, r, index, value);
		segTree[v] = max(segTree[2 * v], segTree[2 * v + 1]);
	}
}

void solveOne() {
	scanf("%d", &n);
	for(int i = 0; i < n; i++) {
		scanf("%d%d%d", &persons[i].a, &persons[i].b, &persons[i].c);
		persons[i].a = n - persons[i].a + 1;
		persons[i].b = n - persons[i].b + 1;
		persons[i].c = n - persons[i].c + 1;
	}
	memset(segTree, 0, sizeof(segTree));
	sort(persons, persons + n);
	int result = 0;
	for(int i = n - 1; i >= 0; i--) {
		int maxBefore = segGet(1, 0, n, persons[i].b + 1, n);
		if(maxBefore <= persons[i].c) {
			++result;
		}
		segInsert(1, 0, n, persons[i].b, persons[i].c);
	}
	printf("%d\n", result);
}

int main() {
	scanf("%d", &tests);
	for(int i = 0; i < tests; i++)
		solveOne();
	return 0;
}